<?php
namespace Pawn;

set_exception_handler(function($e)
{
	ob_end_clean();
	
	\lib\Lang::load('pawn');
	
	\lib\Template::render('pawn/exception.html', array
	(
		'type'		=>	$e->getType(),
		'message'	=>	$e->getMessage(),
		'file'		=>	$e->getFile(),
		'line'		=>	$e->getLine(),
		'query'		=>	$e->getQuery()
	));
	
	exit;
});

class Exception extends \Exception
{
	private $type;
	
	public function __construct($type, $message, $file=null, $line=null, $code=0, $query=false)
	{
		parent::__construct($message, $code);
		
		$this->type = $type;
		
		if($file !== null)
		{
			$this->file = $file;
		}
		
		$this->file = substr($this->file, strlen(ROOT) - 1);
		
		if($line !== null)
		{
			$this->line = $line;
		}
		
		$this->query = $query;
	}
	
	public function getType()
	{
		return $this->type;
	}
	
	public function getQuery()
	{
		return $this->query;
	}
}